import {decl} from 'bem';
import {connect} from 'react-redux';
import {bindActionCreators} from 'redux';
import last from 'lodash/last';
import {selectMatchObj} from 'tools-access-react-redux-router/src/selectors';
import {updateQueryStr, filterMatchStr} from 'tools-access-react-redux-router/src/actions';
import CertCardContainer from 'b:cert-card.container';
import {
    requestCert,
    requestCertAction,
    requestUpdateAbcService,
    requestAdditionalFieldsConfig,
    selector
} from '../../redux/ducks/cert';

function mapStateToProps(state, {path, expr}) {
    return {
        ...selector(state),
        path,
        certId: last(selectMatchObj(state, expr, (v, k) => {
            if (k === 'certId') {
                return {[k]: v};
            }

            return {};
        }).certId)
    };
}

function mapDispatchToProps(dispatch) {
    return bindActionCreators({
        updateQueryStr,
        filterMatchStr,
        requestCert,
        requestCertAction,
        requestUpdateAbcService,
        requestAdditionalFieldsConfig
    }, dispatch);
}

const CertCardConnected = connect(mapStateToProps, mapDispatchToProps)(CertCardContainer);

export default decl({block: 'cert-card.store-connected'}, () => CertCardConnected);
