import React from 'react';
import propTypes from 'prop-types';
import {format as urlFormat} from 'url';
import {decl} from 'bem';
import Button from 'b:button2 m:theme=clear m:type=link m:size=s';
import Icon from 'b:icon m:type=cross-websearch|download|copy-link';
import i18n from 't:i18n';
import CopyLink from 'b:copy-link';

export default decl({
    block: 'cert-card',
    elem: 'controls',

    willInit() {
        this.__base(...arguments);

        this.getCopyLinkURL = ::this.getCopyLinkURL;
    },
    content({
        cert: {id, available_actions},
        onCloseClick
    }) {
        const isButtonAvailable = available_actions.some(({id: actionId}) => actionId === 'download');
        const content = [
            <CopyLink
                key="copy-link"
                getURL={this.getCopyLinkURL}
            />
        ];

        if (isButtonAvailable) {
            content.push(
                <Button
                    key="download"
                    theme="clear"
                    type="link"
                    size="s"
                    url={`/api/frontend/certificate/${encodeURIComponent(id)}/download/?format=pem`}
                    target="_blank"
                    attrs={{title: i18n('download')}}
                >
                    <Icon type="download" />
                </Button>
            );
        }

        content.push(
            <Button
                key="close"
                theme="clear"
                size="s"
                onClick={onCloseClick}
                mix={{
                    block: this.block,
                    elem: 'button-close'
                }}
            >
                <Icon type="cross-websearch" />
            </Button>
        );

        return content;
    },
    getCopyLinkURL() {
        const {cert: {id, serial_number}} = this.props;
        const {protocol, host: hostname} = location;
        const pathname = `/certificates/${id}`;

        return urlFormat({
            protocol,
            hostname,
            pathname,
            query: {
                serial_number
            }
        });
    }
}, {
    propTypes: {
        cert: propTypes.shape({
            available_actions: propTypes.arrayOf(propTypes.shape({
                id: propTypes.string.isRequired
            })).isRequired,
            id: propTypes.number.isRequired
        }).isRequired,
        onCloseClick: propTypes.func.isRequired
    }
});
