import {decl} from 'bem';
import PropTypes from 'prop-types';
import i18n from 't:i18n';

export default decl({
    block: 'cert-card',
    elem: 'field-key',

    tag: 'span',
    content({slug}) {
        return i18n(slug);
    }
}, {
    propTypes: {
        slug: PropTypes.oneOf([
            'can',
            'type',
            'status',
            'platform',
            'expired',
            'id',
            'request-id',
            'issuer',
            'issued-at',
            'issuee-user',
            'issuee-abc-service',
            'granted-by',
            'granted-at',
            'template',
            'tags',
            'private-key-deleted-at',
            'cn',
            'hosts',
            'pc-hostname',
            'pc-os',
            'pc-serial-number',
            'pc-mac',
            'pc-inum',
            'st-issue-key',
            'ticket'
        ]).isRequired
    }
});
