import React from 'react';
import {declMod} from 'bem';
import TaSuggest from 'b:ta-suggest m:size=s m:single';
import Tooltip from 'b:tooltip m:theme=error m:size=s';
import i18n from 'm:type=abc-service t:i18n';

export default declMod({type: 'abc-service'}, {
    block: 'cert-card',
    elem: 'field-val',

    willInit() {
        this.__base(...arguments);

        this._refs = {};
        this.setRefSuggest = this.setRef('suggest');
        this.getRefSuggest = this.getRef('suggest');
    },
    content() {
        const {
            cert: {available_actions},
            onAbcServiceChange: onChange,
            abcServiceUpdateError: error,
            onAbcServiceTooltipOutsideClick: onTooltipOutsideClick,
            abcServiceId
        } = this.props.data;
        const isUpdatePermitted = available_actions.some(({id: actionId}) => actionId === 'update');
        const suggestValue = abcServiceId ? [abcServiceId] : [];

        return [
            <TaSuggest
                key="suggest"
                size="s"
                theme="normal"
                single
                placeholder={i18n('choose')}
                value={suggestValue}
                dataprovider={{pathname: '/api/frontend/suggest/abc_services/'}}
                disabled={!isUpdatePermitted}
                onChange={onChange}
                ref={this.setRefSuggest}
            />,
            <Tooltip
                theme="error"
                key="tooltip"
                visible={Boolean(error)}
                anchor={this.getRefSuggest}
                to="left"
                size="s"
                autoclosable
                onOutsideClick={onTooltipOutsideClick}
            >
                {error}
            </Tooltip>
        ];
    },
    setRef(id) {
        return (elem) => {
            this._refs[id] = elem;
        };
    },
    getRef(id) {
        return /* istanbul ignore next */() => this._refs[id];
    }
}, {
    propTypes: {
        // Todo: use PropTypes when bem-react-core becomes work properly
    }
});
