import {declMod} from 'bem';
import moment from 'moment';

export default declMod({type: 'date'}, {
    block: 'cert-card',
    elem: 'field-val',

    content({data: date}) {
        const momentDate = moment(date);

        if (!momentDate.isValid()) {
            return '—';
        }

        return momentDate.format('D MMM YYYY, HH:mm');
    }
}, {
    propTypes: {
        // Todo: use PropTypes when bem-react-core becomes work properly
    }
});
