import React from 'react';
import {declMod} from 'bem';

export default declMod({type: 'ticket'}, {
    block: 'cert-card',
    elem: 'field-val',

    content({data: ticket}) {
        if (!ticket) {
            return '—';
        }

        return (
            <a
                href={`https://st.yandex-team.ru/${ticket}`}
                target="_blank"
                rel="noopener noreferrer"
            >
                {ticket}
            </a>
        );
    }
});
