import React from 'react';
import {declMod} from 'bem';
import Username from 'b:ta-username';

export default declMod({type: 'user'}, {
    block: 'cert-card',
    elem: 'field-val',

    content({data: user}) {
        if (!user) {
            return '—';
        }

        return (
            <Username
                href={`https://staff.yandex-team.ru/${user}`}
                username={user}
            >
                {user}
            </Username>
        );
    }
}, {
    propTypes: {
        // Todo: use PropTypes when bem-react-core becomes work properly
    }
});
