import React from 'react';
import {decl} from 'bem';
import propTypes from 'prop-types';
import Key from 'e:field-key';
import Val from 'e:field-val m:type=text|date|user|abc-service|list|tags|ticket';

export default decl({
    block: 'cert-card',
    elem: 'field',

    content({type, fieldKey, fieldVal}) {
        return [
            <Key
                key="key"
                slug={fieldKey}
            />,
            <Val
                key="val"
                type={type}
                data={fieldVal}
            />
        ];
    }
}, {
    propTypes: {
        type: propTypes.oneOf(['text', 'date', 'user', 'abc-service', 'list', 'tags', 'ticket'])
    }
});
