import React from 'react';
import {decl} from 'bem';
import propTypes from 'prop-types';
import Field from 'e:field';

export default decl({
    block: 'cert-card',
    elem: 'fields',

    content({fields}) {
        return fields.map(({slug, type, data}) => (
            <Field
                key={slug}
                type={type}
                fieldKey={slug}
                fieldVal={data}
            />
        ));
    }
}, {
    propTypes: {
        fields: propTypes.array.isRequired
    }
});
