import React from 'react';
import {declMod} from 'bem';
import Fields from 'e:fields';

export default declMod({type: 'host-certum-prod'}, {
    block: 'cert-card',
    elem: 'secondary-fields-set',

    content() {
        const {
            request_id,
            st_issue_key,
            hosts = []
        } = this.props.cert;

        return [
            <Fields
                key="fields-only-for-host-certum-prod"
                fields={[
                    {
                        slug: 'st-issue-key',
                        type: 'text',
                        data: st_issue_key
                    },
                    {
                        slug: 'request-id',
                        type: 'text',
                        data: request_id
                    }
                ]}
            />,
            <Fields
                key="fields-only-for-host"
                fields={[
                    {
                        slug: 'issuee-abc-service',
                        type: 'abc-service',
                        data: this.props
                    },
                    {
                        slug: 'hosts',
                        type: 'list',
                        data: hosts
                    }
                ]}
            />,
            ...this.__base(...arguments)
        ];
    }
});
