import React from 'react';
import {declMod} from 'bem';
import Fields from 'e:fields';

export default declMod({type: 'host'}, {
    block: 'cert-card',
    elem: 'secondary-fields-set',

    content() {
        const {hosts = []} = this.props.cert;

        return [
            <Fields
                key="fields-only-for-host"
                fields={[
                    {
                        slug: 'issuee-abc-service',
                        type: 'abc-service',
                        data: this.props
                    },
                    {
                        slug: 'hosts',
                        type: 'list',
                        data: hosts
                    }
                ]}
            />,
            ...this.__base(...arguments)
        ];
    }
});
