import React from 'react';
import {declMod} from 'bem';
import Fields from 'e:fields';

export default declMod({type: 'pc'}, {
    block: 'cert-card',
    elem: 'secondary-fields-set',

    content() {
        const {
            user,
            pc_hostname,
            pc_os,
            pc_serial_number,
            pc_mac,
            pc_inum
        } = this.props.cert;

        return [
            <Fields
                key="fields-only-for-pc"
                fields={[
                    {
                        slug: 'issuee-user',
                        type: 'user',
                        data: user.username
                    },
                    {
                        slug: 'pc-hostname',
                        type: 'text',
                        data: pc_hostname
                    },
                    {
                        slug: 'pc-os',
                        type: 'text',
                        data: pc_os
                    },
                    {
                        slug: 'pc-serial-number',
                        type: 'text',
                        data: pc_serial_number
                    },
                    {
                        slug: 'pc-mac',
                        type: 'text',
                        data: pc_mac
                    },
                    {
                        slug: 'pc-inum',
                        type: 'text',
                        data: pc_inum
                    }
                ]}
            />,
            ...this.__base(...arguments)
        ];
    }
});
