import React from 'react';
import {decl} from 'bem';
import Fields from 'e:fields';

export default decl({
    block: 'cert-card',
    elem: 'secondary-fields-set',

    content() {
        const {
            common_name,
            id,
            requester,
            added,
            issued,
            used_template,
            tags,
            priv_key_deleted_at,
            helpdesk_ticket
        } = this.props.cert;

        return [
            <Fields
                key="fields-one"
                fields={[
                    {
                        slug: 'cn',
                        type: 'text',
                        data: common_name
                    },
                    {
                        slug: 'id',
                        type: 'text',
                        data: id
                    }
                ]}
            />,
            <Fields
                key="fields-two"
                fields={[
                    {
                        slug: 'issuer',
                        type: 'user',
                        data: requester.username
                    },
                    {
                        slug: 'issued-at',
                        type: 'date',
                        data: added
                    },
                    {
                        slug: 'granted-at',
                        type: 'date',
                        data: issued
                    },
                    {
                        slug: 'private-key-deleted-at',
                        type: 'date',
                        data: priv_key_deleted_at
                    },
                    {
                        slug: 'ticket',
                        type: 'ticket',
                        data: helpdesk_ticket
                    }
                ]}
            />,
            <Fields
                key="fields-four"
                fields={[
                    {
                        slug: 'template',
                        type: 'text',
                        data: used_template
                    },
                    {
                        slug: 'tags',
                        type: 'tags',
                        data: tags
                    }
                ]}
            />
        ];
    }
});
