import React from 'react';
import propTypes from 'prop-types';
import {declMod} from 'bem';
import i18n from 't:i18n';
import Title from 'e:title';
import ErrorText from 'b:error-text';
import Button from 'b:button2 m:theme=normal|action m:size=s m:view=default m:tone=default';

export default declMod({'is-error': true}, {
    block: 'cert-card',

    content({fetchError, onCloseClick, onRetryClick}) {
        return [
            <Title
                key="title"
                text={i18n('title-error')}
            />,
            <ErrorText
                key="error-text"
            >
                {JSON.stringify(fetchError, null, 2)}
            </ErrorText>,
            <div key="controls">
                <Button
                    theme="action"
                    size="s"
                    view="default"
                    tone="default"
                    mix={[
                        {
                            block: this.block,
                            elem: 'button'
                        },
                        {
                            block: this.block,
                            elem: 'button-retry'
                        }
                    ]}
                    onClick={onRetryClick}
                >
                    {i18n('retry')}
                </Button>
                <Button
                    theme="normal"
                    size="s"
                    view="default"
                    tone="default"
                    mix={{
                        block: this.block,
                        elem: 'button'
                    }}
                    onClick={onCloseClick}
                >
                    {i18n('close')}
                </Button>
            </div>
        ];
    }
}, {
    propTypes: {
        fetchError: propTypes.instanceOf(Error),
        onCloseClick: propTypes.func,
        onRetryClick: propTypes.func
    }
});
