/* global process */

import React from 'react';
import propTypes from 'prop-types';
import {decl} from 'bem';
import i18n from 't:i18n';
import Title from 'e:title';
import Controls from 'e:controls';
import Fields from 'e:fields';
import Actions from 'e:actions';
import SecondaryFieldsSet from 'e:secondary-fields-set m:type=host|host-certum-prod|pc';
import Sections from 'b:ta-sections';
import Sn from 'b:serial-number';

const {BEM_LANG} = process.env;

export default decl({
    block: 'cert-card',

    attrs({setRef}) {
        return {
            ...this.__base(),
            ref: setRef
        };
    },
    content() {
        const {
            serial_number,
            common_name,
            ca_name,
            type_human,
            status_human: {[BEM_LANG]: status},
            device_platform,
            end_date
        } = this.props.cert;

        return [
            <Controls
                {...this.props}
                key="controls"
            />,
            <Title
                key="title"
                text={common_name}
            />,
            <Sn
                key="sn"
                value={serial_number}
                mix={{
                    block: this.block,
                    elem: 'sn'
                }}
            />,
            <Fields
                key="fields-main"
                fields={[
                    {
                        slug: 'can',
                        type: 'text',
                        data: ca_name
                    },
                    {
                        slug: 'type',
                        type: 'text',
                        data: type_human[BEM_LANG]
                    },
                    {
                        slug: 'status',
                        type: 'text',
                        data: status
                    },
                    {
                        slug: 'platform',
                        type: 'text',
                        data: device_platform
                    },
                    {
                        slug: 'expired',
                        type: 'date',
                        data: end_date
                    }
                ]}
            />,
            <Actions
                {...this.props}
                key="actions"
            />,
            <Sections
                key="sections"
                size="m"
                mix={{
                    block: this.block,
                    elem: 'sections'
                }}
            >
                <Sections.Section
                    href=""
                    current
                >
                    {i18n('info')}
                </Sections.Section>
            </Sections>,
            <SecondaryFieldsSet
                {...this.props}
                key="secondary-fields-set"
                type={this.getSecondaryFieldsSetType(this.props.cert)}
            />
        ];
    },

    getSecondaryFieldsSetType({type, ca_name}) {
        let value = type;

        if (type === 'host' && ['CertumProductionCA', 'GlobalSignProductionCA'].includes(ca_name)) {
            value = 'host-certum-prod';
        } else if (['pc', 'bank-pc', 'linux-pc', 'zombie'].includes(type)) {
            value = 'pc';
        }

        return value;
    }
}, {
    propTypes: {
        cert: propTypes.shape({
            serial_number: propTypes.string.isRequired,
            common_name: propTypes.string.isRequired,
            ca_name: propTypes.string.isRequired,
            type_human: propTypes.shape({
                [BEM_LANG]: propTypes.string.isRequired
            }).isRequired,
            status_human: propTypes.shape({
                [BEM_LANG]: propTypes.string.isRequired
            }).isRequired,
            device_platform: propTypes.string.isRequired,
            end_date: propTypes.string.isRequired
        }).isRequired
    }
});
