import React from 'react';
import {decl} from 'bem';
import Form from 'b:cert-request-form';
import Component from 'b:ta-component';
import propTypes from 'prop-types';

export const CERT_REQUEST_FORM_PARAM = 'cr-form';

export default decl(Component, {
    block: 'cert-request-form.container',

    willInit() {
        this.handleShowButtonClick = this.handleShowButtonClick.bind(this);
        this.handleCancelButtonClick = this.handleCancelButtonClick.bind(this);
    },
    replace(props) {
        const {crForm, formQueryParams} = props;
        const isFormVisible = Boolean(crForm && crForm === '1');

        return (
            <Form
                {...props}
                initialFieldsValues={formQueryParams}
                isFormVisible={isFormVisible}
                onShowButtonClick={this.handleShowButtonClick}
                onCancelButtonClick={this.handleCancelButtonClick}
            />
        );
    },
    handleShowButtonClick() {
        this.props.updateQueryStr({[CERT_REQUEST_FORM_PARAM]: '1'});
    },
    handleCancelButtonClick() {
        this.hideForm();
    },
    hideForm() {
        this.props.clearAdditionalFieldsConfig();
        this.props.filterQueryStr((v, k) => k !== CERT_REQUEST_FORM_PARAM);
    }
}, {
    propTypes: {
        crForm: propTypes.string,
        filterQueryStr: propTypes.func.isRequired,
        formQueryParams: propTypes.object.isRequired,
        path: propTypes.string.isRequired,
        updateQueryStr: propTypes.func.isRequired
    }
});
