import {decl} from 'bem';
import {connect} from 'react-redux';
import {bindActionCreators} from 'redux';
import last from 'lodash/last';
import {filterQueryStr, updateQueryStr} from 'tools-access-react-redux-router/src/actions';
import {selectQueryObj} from 'tools-access-react-redux-router/src/selectors';
import CertRequestFormContainer from 'b:cert-request-form.container';
import {CERT_REQUEST_FORM_PARAM} from '../cert-request-form.container/cert-request-form.container.react';
import {
    requestAdditionalFieldsConfig,
    clearAdditionalFieldsConfig,
    requestCreateCert,
    selector
} from '../../redux/ducks/cert-request-form';
import {requestCerts, selector as selectorCerts} from '../../redux/ducks/certs';

function mapStateToProps(state) {
    const {filtersKeys} = selectorCerts(state);
    const queryKeys = [...filtersKeys, 'page'];
    const queryKeysSet = new Set(queryKeys);

    const filtersQueryParams = selectQueryObj(state, (v, k) => {
        if (queryKeysSet.has(k)) {
            return {[k]: v};
        }

        return {};
    });

    queryKeys.forEach((key) => {
        filtersQueryParams[key] = last(filtersQueryParams[key] || ['']);
    });

    const formQueryParams = selectQueryObj(state, (v, k) => {
        if (k.startsWith('cr-form-')) {
            return {
                [k.replace(/^cr-form-/, '')]: v
            };
        }

        return {};
    });

    Object.keys(formQueryParams).forEach((key) => {
        formQueryParams[key] = last(formQueryParams[key]);
    });

    return {
        ...selector(state),
        ...selectorCerts(state),
        crForm: last(selectQueryObj(state, (v, k) => {
            if (k === CERT_REQUEST_FORM_PARAM) {
                return {[k]: v};
            }

            return {};
        })[CERT_REQUEST_FORM_PARAM]) || null,
        formQueryParams,
        filtersQueryParams
    };
}

function mapDispatchToProps(dispatch) {
    return bindActionCreators({
        filterQueryStr,
        updateQueryStr,
        selectQueryObj,
        requestAdditionalFieldsConfig,
        clearAdditionalFieldsConfig,
        requestCreateCert,
        requestCerts
    }, dispatch);
}

const CertRequestFormConnected = connect(mapStateToProps, mapDispatchToProps)(CertRequestFormContainer);

export default decl({block: 'cert-request-form.store-connected'}, () => CertRequestFormConnected);
