import React from 'react';
import PropTypes from 'prop-types';
import {declMod} from 'bem';
import Button from 'b:button2 m:theme=action|normal m:size=m';
import i18n from 't:i18n';

export default declMod({'submit-result': 'success'}, {
    block: 'cert-request-form',
    elem: 'controls',

    content({onCancelButtonClick}) {
        return (
            <Button
                key="close"
                theme="action"
                size="m"
                onClick={onCancelButtonClick}
                mix={{
                    block: this.block,
                    elem: 'button',
                    mods: {type: 'close'}
                }}
            >
                {i18n('close')}
            </Button>
        );
    }
}, {
    propTypes: {
        onCancelButtonClick: PropTypes.func
    }
});
