import React from 'react';
import PropTypes from 'prop-types';
import {decl} from 'bem';
import Button from 'b:button2 m:theme=action|normal m:size=m';
import i18n from 't:i18n';
import Spin from 'b:spin2 m:size=m m:progress=yes';

export default decl({
    block: 'cert-request-form',
    elem: 'controls',

    content({isIssueButtonAvailable, onCancelButtonClick, onIssueButtonClick, isRequestCertInProgress}) {
        const content = [
            <Button
                key="issue"
                theme="action"
                size="m"
                disabled={!isIssueButtonAvailable || isRequestCertInProgress}
                onClick={onIssueButtonClick}
                mix={{
                    block: this.block,
                    elem: 'button',
                    mods: {type: 'issue'}
                }}
            >
                {i18n('issue')}
            </Button>,
            <Button
                key="cancel"
                theme="normal"
                size="m"
                disabled={isRequestCertInProgress}
                onClick={onCancelButtonClick}
                mix={{
                    block: this.block,
                    elem: 'button',
                    mods: {type: 'cancel'}
                }}
            >
                {i18n('cancel')}
            </Button>
        ];

        if (isRequestCertInProgress) {
            content.push(
                <Spin
                    key="spinner"
                    size="m"
                    progress
                />
            );
        }

        return content;
    }
}, {
    propTypes: {
        isIssueButtonAvailable: PropTypes.bool,
        onCancelButtonClick: PropTypes.func,
        onIssueButtonClick: PropTypes.func
    }
});
