import React from 'react';
import {declMod} from 'bem';
import Checkbox from 'b:checkbox m:theme=normal m:size=m';

export default declMod({type: 'bool'}, {
    block: 'cert-request-form',
    elem: 'field',

    willInit() {
        this.__base(...arguments);

        this.handleChange = ::this.handleChange;
    },
    content({value, disabled}) {
        return [
            this.__base(...arguments),
            <Checkbox
                key="control"
                theme="normal"
                size="m"
                onChange={this.handleChange}
                checked={value.toString() === 'true'}
                disabled={disabled}
                mix={{
                    block: this.block,
                    elem: 'control-checkbox'
                }}
            />
        ];
    },
    handleChange() {
        const {onFieldChange, value} = this.props;

        onFieldChange(!(value.toString() === 'true'));
    }
}, {
    propTypes: {
        // Todo: use when bem-react-core becomes work properly
    }
});
