import React from 'react';
import {declMod} from 'bem';
import TaSuggest from 'b:ta-suggest m:size=m m:single';
import i18n from 'm:type=suggest t:i18n';
import compact from 'lodash/compact';
import kebabCase from 'lodash/kebabCase';

export default declMod({type: 'suggest'}, {
    block: 'cert-request-form',
    elem: 'field',

    willInit() {
        this.__base(...arguments);

        this.handleChange = ::this.handleChange;
    },
    content({disabled, dataprovider, value, slug}) {
        return [
            this.__base(...arguments),
            <TaSuggest
                key="control"
                size="m"
                theme="normal"
                single
                placeholder={i18n('choose')}
                value={compact([value])}
                dataprovider={dataprovider}
                onChange={this.handleChange}
                disabled={disabled}
                mix={{
                    block: this.block,
                    elem: 'control-suggest',
                    mods: {slug: kebabCase(slug)}
                }}
            />
        ];
    },
    handleChange(value) {
        const {id = ''} = {...value};

        this.props.onFieldChange(id);
    }
}, {
    propTypes: {
        // Todo: use when bem-react-core becomes work properly
    }
});
