import React from 'react';
import {declMod} from 'bem';
import Textinput from 'b:textinput m:theme=normal m:size=m';
import kebabCase from 'lodash/kebabCase';

export default declMod({type: 'textinput'}, {
    block: 'cert-request-form',
    elem: 'field',

    content({value, onFieldChange, disabled, slug}) {
        return [
            this.__base(...arguments),
            <Textinput
                key="control"
                theme="normal"
                size="m"
                onChange={onFieldChange}
                text={value}
                disabled={disabled}
                mix={{
                    block: this.block,
                    elem: 'control-textinput',
                    mods: {slug: kebabCase(slug)}
                }}
            />
        ];
    }
}, {
    propTypes: {
        // Todo: use when bem-react-core becomes work properly
    }
});
