import React from 'react';
import {declMod} from 'bem';
import propTypes from 'prop-types';
import Title from 'b:ta-title';
import Controls from 'e:controls m:submit-result=success|fail';
import ErrorText from 'b:error-text';
import i18n from 't:i18n';

export default declMod({submitted: true}, {
    block: 'cert-request-form',
    elem: 'modal-content',

    content({requestError, onRetryButtonClick, onCancelButtonClick}) {
        const submitResult = requestError === null ? 'success' : 'fail';
        const content = [
            <Title
                key="title"
                level={3}
                size="m"
                font="m"
            >
                {i18n(`title-request-${submitResult}`)}
            </Title>
        ];

        if (submitResult === 'fail') {
            content.push(
                <ErrorText
                    key="error-text"
                >
                    {JSON.stringify(requestError, null, 2)}
                </ErrorText>
            );
        }

        content.push(
            <Controls
                key="controls"
                submit-result={submitResult}
                onCancelButtonClick={onCancelButtonClick}
                onRetryButtonClick={onRetryButtonClick}
            />
        );

        return content;
    }
}, {
    propTypes: {
        onCancelButtonClick: propTypes.func.isRequired,
        onRetryButtonClick: propTypes.func.isRequired,
        requestError: propTypes.instanceOf(Error)
    }
});
