import React from 'react';
import {decl} from 'bem';
import PropTypes from 'prop-types';
import Button from 'b:button2 m:theme=raised m:size=l';
import Modal from 'b:modal m:theme=normal';
import ModalContentC from 'e:modal-content.container';
import i18n from 't:i18n';

export default decl({
    block: 'cert-request-form',

    content(props) {
        const {
            onShowButtonClick,
            isFormVisible
        } = props;

        const content = [
            <Button
                key="button-show-form"
                theme="raised"
                size="l"
                onClick={onShowButtonClick}
            >
                {i18n('issue-cert')}
            </Button>
        ];

        if (isFormVisible) {
            content.push(
                <Modal
                    key="modal"
                    theme="normal"
                    visible
                >
                    <ModalContentC
                        {...this.props}
                    />
                </Modal>
            );
        }

        return content;
    }
}, {
    propTypes: {
        isFormVisible: PropTypes.bool.isRequired,
        onShowButtonClick: PropTypes.func.isRequired
    }
});
