import {decl} from 'bem';
import {connect} from 'react-redux';
import {bindActionCreators} from 'redux';
import last from 'lodash/last';
import {selectQueryObj, selectMatchObj} from 'tools-access-react-redux-router/src/selectors';
import {updateMatchStr, filterQueryStr, updateQueryStr} from 'tools-access-react-redux-router/src/actions';
import CertsTableContainer from 'b:certs-table.container';
import {requestCerts, selector} from '../../redux/ducks/certs';

function mapStateToProps(store, {path, expr}) {
    return {
        ...selector(store),
        path,
        page: last(selectQueryObj(store, (v, k) => {
            if (k === 'page') {
                return {[k]: v};
            }

            return {};
        }).page) || '1',

        activeCertId: last(selectMatchObj(store, expr, (v, k) => {
            if (k === 'certId') {
                return {
                    [k]: v
                };
            }

            return {};
        }).certId) || null
    };
}

function mapDispatchToProps(dispatch) {
    return bindActionCreators({
        filterQueryStr,
        updateQueryStr,
        updateMatchStr,
        requestCerts
    }, dispatch);
}

const CertsTableConnected = connect(mapStateToProps, mapDispatchToProps)(CertsTableContainer);

export default decl({block: 'certs-table.store-connected'}, () => CertsTableConnected);
