import {decl} from 'bem';
import moment from 'moment';
import PropTypes from 'prop-types';

moment.locale('ru');

export default decl({
    block: 'certs-table',
    elem: 'date-year',

    mods({theme}) {
        return {theme};
    },
    content({date}) {
        return moment(date).format('YYYY');
    }
}, {
    propTypes: {
        date: PropTypes.string.isRequired,
        theme: PropTypes.string
    }
});
