import React from 'react';
import {decl} from 'bem';
import Tr from 'e:tr';
import propTypes from 'prop-types';

export default decl({
    block: 'certs-table',
    elem: 'tbody',
    tag: 'tbody',
    content({activeCertId, certs, onTrClick}) {
        return certs.items.map((certData) => (
            <Tr
                isActive={String(certData.id) === activeCertId}
                key={certData.id}
                certData={certData}
                onTrClick={onTrClick}
            />
        ));
    }
}, {
    propTypes: {
        activeCertId: propTypes.string,
        certs: propTypes.shape({
            items: propTypes.arrayOf(propTypes.shape({
                id: propTypes.number.isRequired
            })).isRequired
        }).isRequired,
        onTrClick: propTypes.func.isRequired
    }
});
