import React from 'react';
import {declMod} from 'bem';
import moment from 'moment';
import PropTypes from 'prop-types';
import DateShort from 'e:date-short';
import DateYear from 'e:date-year';

moment.locale('ru');

export default declMod({type: 'date'}, {
    block: 'certs-table',
    elem: 'td',
    content({date, theme}) {
        const momentDate = moment(date, moment.ISO_8601);

        if (!momentDate.isValid()) {
            return '—';
        }

        if (momentDate.isSame(moment(), 'year')) {
            return <DateShort date={date} />;
        }

        return [
            <DateShort
                key="short"
                date={date}
            />,
            <DateYear
                key="year"
                date={date}
                theme={theme}
            />
        ];
    }
}, {
    propTypes: {
        // Todo: use .isRequired
        date: PropTypes.string,
        theme: PropTypes.any
    }
});
