import React from 'react';
import {declMod} from 'bem';
import propTypes from 'prop-types';
import Pager from 'b:ta-pager';
import Spin from 'b:spin2 m:size=s m:progress=yes';

export default declMod({type: 'foot'}, {
    block: 'certs-table',
    elem: 'td',

    attrs({colSpan}) {
        return {
            ...this.__base(...arguments),
            colSpan
        };
    },
    content({certs: {page, count, perPage}, onPagerChange, isFetching, numberOfPages}) {
        const content = [];

        if (count > perPage) {
            content.push(
                <Pager
                    key="pager"
                    page={page}
                    count={numberOfPages}
                    onChange={onPagerChange}
                    mix={{
                        block: this.block,
                        elem: 'pager'
                    }}
                />
            );
        }

        if (isFetching) {
            content.push(
                <Spin
                    key="spin"
                    size="s"
                    progress
                />
            );
        }

        return content;
    }
}, {
    propTypes: {
        colSpan: propTypes.number
    }
});
