import {declMod} from 'bem';
import i18n from 'm:type=no-data t:i18n';
import PropTypes from 'prop-types';

export default declMod({type: 'no-data'}, {
    block: 'certs-table',
    elem: 'td',

    attrs({colSpan}) {
        return {
            ...this.__base(...arguments),
            colSpan
        };
    },
    content() {
        return i18n('no-data');
    }
}, {
    propTypes: {
        colSpan: PropTypes.number
    }
});
