import React from 'react';
import {declMod} from 'bem';
import Sn from 'b:serial-number';
import Cn from 'e:cn';
import propTypes from 'prop-types';

export default declMod({type: 'serial-num'}, {
    block: 'certs-table',
    elem: 'td',
    content({sn, cn, theme}) {
        return [
            <Cn
                key="cn"
                cn={cn}
            />,
            <Sn
                key="sn"
                value={sn}
                mix={{
                    block: this.block,
                    elem: 'sn',
                    mods: {theme}
                }}
            />
        ];
    }
}, {
    propTypes: {
        cn: propTypes.string,
        sn: propTypes.string,
        theme: propTypes.string
    }
});
