import React from 'react';
import {declMod} from 'bem';
import Username from 'b:ta-username';
import PropTypes from 'prop-types';

export default declMod({type: 'user'}, {
    block: 'certs-table',
    elem: 'td',
    content({user, theme}) {
        return (
            <Username
                href={`https://staff.yandex-team.ru/${user}`}
                mix={{
                    block: this.block,
                    elem: 'user',
                    mods: {theme}
                }}
                username={user}
            >
                {user}
            </Username>
        );
    }
}, {
    propTypes: {
        // Todo: use .isRequired
        theme: PropTypes.string,
        user: PropTypes.string
    }
});
