/* global process */

import React from 'react';
import {decl} from 'bem';
import PropTypes from 'prop-types';
import Td from 'e:td m:type=date|serial-num|status|user';

const {BEM_LANG} = process.env;

export default decl({
    block: 'certs-table',
    elem: 'tr',
    tag: 'tr',

    attrs({onTrClick, certData: {id}}) {
        return {
            'data-id': id,
            onClick: onTrClick
        };
    },
    mods() {
        return {'is-active': this.props.isActive};
    },
    content({certData, isActive}) {
        const {
            serial_number,
            common_name,
            ca_name,
            type_human: {[BEM_LANG]: type},
            requester: {username},
            status_human: {[BEM_LANG]: status},
            added,
            issued,
            end_date
        } = certData;
        const theme = isActive ? 'contrast' : '';

        return [
            <Td
                key="sn"
                type="serial-num"
                sn={serial_number}
                cn={common_name}
                theme={theme}
            />,
            <Td
                key="type"
                theme={theme}
            >
                {type}
            </Td>,
            <Td
                key="can"
                theme={theme}
            >
                {ca_name}
            </Td>,
            <Td
                key="user"
                type="user"
                user={username}
                theme={theme}
            />,
            <Td
                key="status"
                type="status"
                status={status}
                theme={theme}
            />,
            <Td
                key="requested-at"
                type="date"
                date={added}
                theme={theme}
            />,
            <Td
                key="granted-at"
                type="date"
                date={issued}
                theme={theme}
            />,
            <Td
                key="expired-at"
                type="date"
                date={end_date}
                theme={theme}
            />
        ];
    }
}, {
    propTypes: {
        certData: PropTypes.shape({
            id: PropTypes.number.isRequired,
            ca_name: PropTypes.string.isRequired,
            serial_number: PropTypes.string.isRequired,
            common_name: PropTypes.string.isRequired,
            type_human: PropTypes.shape({
                [BEM_LANG]: PropTypes.string.isRequired
            }).isRequired,
            requester: PropTypes.shape({
                username: PropTypes.string.isRequired
            }).isRequired,
            status_human: PropTypes.shape({
                [BEM_LANG]: PropTypes.string.isRequired
            }).isRequired,
            added: PropTypes.string.isRequired,
            issued: PropTypes.string.isRequired,
            end_date: PropTypes.string.isRequired
        }),
        isActive: PropTypes.bool.isRequired,
        onTrClick: PropTypes.func.isRequired
    }
});
