import React from 'react';
import propTypes from 'prop-types';
import {decl} from 'bem';
import Thead from 'e:thead';
import Tbody from 'e:tbody m:no-data m:loading';
import Tfoot from 'e:tfoot';

export default decl({
    block: 'certs-table',
    tag: 'table',

    content({certs, isFetching}) {
        return [
            <Thead key="thead" />,
            <Tbody
                {...this.props}
                key="tbody"
                loading={isFetching}
                no-data={certs.items.length === 0}
            />,
            <Tfoot
                {...this.props}
                key="tfoot"
            />
        ];
    }
}, {
    propTypes: {
        certs: propTypes.shape({
            items: propTypes.array.isRequired
        }).isRequired,
        isFetching: propTypes.bool.isRequired
    }
});
