import React from 'react';
import {decl} from 'bem';
import propTypes from 'prop-types';
import CertsList from 'b:certs';
import Component from 'b:ta-component';

export default decl(Component, {
    block: 'certs.container',

    willInit() {
        this.__base(...arguments);

        this.getFilters = ::this.getFilters;
    },
    replace({filtersKeys, additionalFiltersKeys}) {
        return (
            <CertsList
                {...this.props}
                filtersKeys={filtersKeys}
                getFilters={this.getFilters}
                additionalFiltersKeys={additionalFiltersKeys}
                getDefaultFilters={this.getDefaultFilters}
            />
        );
    },
    getDefaultFilters() {
        return this.props.defaultFilters;
    },
    getFilters() {
        return this.props.filters;
    }
}, {
    propTypes: {
        defaultFilters: propTypes.object.isRequired,
        filters: propTypes.object.isRequired
    }
});
