import {decl} from 'bem';
import {connect} from 'react-redux';
import {bindActionCreators} from 'redux';
import last from 'lodash/last';
import CertsListContainer from 'b:certs.container';
import {requestCerts, selector} from '../../redux/ducks/certs';
import {disableScroll, enableScroll} from '../../actions/page-scroll';
import {selectQueryObj} from 'tools-access-react-redux-router/src/selectors';

function mapStateToProps(state) {
    const {filtersKeys} = selector(state);

    const filterKeysSet = new Set(filtersKeys);

    const defaultFilters = filtersKeys.reduce((acc, key) => {
        acc[key] = [''];

        return acc;
    }, {});

    const filters = selectQueryObj(state, (v, k) => {
        if (filterKeysSet.has(k)) {
            return {[k]: v};
        }

        return {};
    });

    filtersKeys.forEach((key) => {
        filters[key] = last(filters[key] || defaultFilters[key]);
    });

    return {
        ...selector(state),
        defaultFilters,
        filters
    };
}

function mapDispatchToProps(dispatch) {
    return bindActionCreators({
        requestCerts,
        enableScroll,
        disableScroll
    }, dispatch);
}

const CertsListConnected = connect(mapStateToProps, mapDispatchToProps)(CertsListContainer);

export default decl({block: 'certs.store-connected'}, () => CertsListConnected);
