import React from 'react';
import {decl} from 'bem';
import CertsSC from 'b:certs.store-connected';
import CertCardSC from 'b:cert-card.store-connected';
import Router from 'tools-access-react-redux-router/src/router';
import Route from 'tools-access-react-redux-router/src/route';
import {Consumer} from 'tools-access-react-redux-router/src/context';

export default decl({
    block: 'content',
    elem: 'certs-wrapper',

    content() {
        return [
            <Router key="certs">
                <Route expr="/:certId?">
                    <Consumer>
                        {({path, expr}) => (
                            <CertsSC
                                {...this.props}
                                path={path}
                                expr={expr}
                            />
                        )}
                    </Consumer>
                </Route>
            </Router>,
            <Router key="cert-card">
                <Route expr="/:certId">
                    <Consumer>
                        {({path, expr}) => (
                            <CertCardSC
                                path={path}
                                expr={expr}
                            />
                        )}
                    </Consumer>
                </Route>
            </Router>
        ];
    }
});
