import React from 'react';
import {decl} from 'bem';
import i18n from 'b:content t:i18n';
import Title from 'b:ta-title';
import CertsWrapper from 'e:certs-wrapper';
import FormSC from 'b:cert-request-form.store-connected';
import Route from 'tools-access-react-redux-router/src/route';
import {Consumer} from 'tools-access-react-redux-router/src/context';

export default decl({
    block: 'content',

    content() {
        return [
            <Route
                key="form-sc"
                expr="/:certId?"
            >
                <Consumer>
                    {({path, expr}) => (
                        <FormSC
                            path={path}
                            expr={expr}
                            key="form"
                            mix={{
                                block: this.block,
                                elem: 'form'
                            }}
                        />
                    )}
                </Consumer>
            </Route>,
            <Title
                key="title"
                font="l"
                size="l"
                mix={{
                    block: this.block,
                    elem: 'title'
                }}
            >
                {i18n('certificates')}
            </Title>,
            <CertsWrapper key="table-wrapper" />
        ];
    }
});
