import React from 'react';
import propTypes from 'prop-types';
import {decl} from 'bem';
import Button from 'b:button2 m:theme=clear m:type=link m:size=s';
import Icon from 'b:icon m:type=cross-websearch|download|copy-link';
import Popup from 'b:popup2 m:theme=normal';
import Input from 'b:textinput m:theme=normal m:size=s';
import i18n from 'b:copy-link t:i18n';

export default decl({
    block: 'copy-link',

    willInit() {
        this.__base(...arguments);

        this._refs = {};
        this.state = {
            isPopupVisible: false,
            text: ''
        };
        this.setRefButton = this.setRef('button');
        this.getRefButton = this.getRef('button');

        this.setRefInput = this.setRef('input');
        this.getRefInput = this.getRef('input');

        this.handleButtonClick = ::this.handleButtonClick;
        this.handlePopupOutsideClick = ::this.handlePopupOutsideClick;
    },
    content() {
        const {isPopupVisible, text} = this.state;

        return [
            <Button
                ref={this.setRefButton}
                key="button"
                theme="clear"
                size="s"
                onClick={this.handleButtonClick}
                attrs={{title: i18n('copy-link')}}
            >
                <Icon type="copy-link" />
            </Button>,
            <Popup
                key="popup"
                theme="normal"
                anchor={this.getRefButton}
                directions={['left-center']}
                mix={{
                    block: this.block,
                    elem: 'popup'
                }}
                visible={isPopupVisible}
                autoclosable
                onOutsideClick={this.handlePopupOutsideClick}
                hasTail
            >
                <Input
                    text={text}
                    theme="normal"
                    size="s"
                    ref={this.setRefInput}
                />
            </Popup>
        ];
    },
    handleButtonClick() {
        const inputRef = this.getRefInput();

        this.setState({
            isPopupVisible: true,
            text: this.props.getURL()
        }, () => {
            // TODO: http://st/CERTOR-1243
            setTimeout(() => {
                inputRef._control.select();
                document.execCommand('copy');
            }, 0);
        });
    },
    handlePopupOutsideClick() {
        this.setState({isPopupVisible: false});
    },
    setRef(id) {
        return (elem) => {
            this._refs[id] = elem;
        };
    },
    getRef(id) {
        return () => this._refs[id];
    }
}, {
    propTypes: {
        getURL: propTypes.func.isRequired
    }
});
