import React from 'react';
import propTypes from 'prop-types';
import {decl} from 'bem';
import Component from 'b:ta-component';
import Filters from 'b:filters';

export default decl(Component, {
    block: 'filters.container',

    willInit() {
        this.__base(...arguments);

        this.state = {
            isAdditionalFiltersVisible: false,
            filtersUnapplied: {}
        };

        this.getHandleFilterChange = ::this.getHandleFilterChange;
        this.handleToggleAdditionalFiltersClick = ::this.handleToggleAdditionalFiltersClick;
        this.handleApplyClick = ::this.handleApplyClick;
        this.handleClearClick = ::this.handleClearClick;
    },
    replace() {
        const {isAdditionalFiltersVisible, filtersUnapplied} = this.state;
        const {getFilters} = this.props;
        const filters = getFilters();

        const mergedFilters = Object.assign({}, filters, filtersUnapplied);

        return (
            <Filters
                filters={mergedFilters}
                additionalFiltersAppliedNum={this.getAdditionalFiltersNum(filters)}
                getOnFilterChange={this.getHandleFilterChange}
                onToggleAdditionalFiltersClick={this.handleToggleAdditionalFiltersClick}
                isAdditionalFiltersVisible={isAdditionalFiltersVisible}
                onApplyClick={this.handleApplyClick}
                onClearClick={this.handleClearClick}
            />);
    },
    getHandleFilterChange(type) {
        return (value) => {
            if (this.state.isAdditionalFiltersVisible) {
                this.setState((prevState) => ({
                    ...prevState,
                    filtersUnapplied: {
                        ...prevState.filtersUnapplied,
                        [type]: value
                    }
                }));

                return;
            }

            this.props.updateQueryStr({[type]: value});
        };
    },
    handleApplyClick() {
        this.hideAdditionalFilters();
        this.props.updateQueryStr(this.state.filtersUnapplied);
        this.setState({filtersUnapplied: {}});
    },
    getAdditionalFiltersNum(filters) {
        return this.props.additionalFiltersKeys.filter((key) => filters[key]).length;
    },
    handleClearClick() {
        const filterKeysSet = new Set(this.props.filtersKeys);

        this.hideAdditionalFilters();
        this.props.filterQueryStr((v, k) => !filterKeysSet.has(k));
        this.setState({filtersUnapplied: {}});
    },
    handleToggleAdditionalFiltersClick() {
        if (this.state.isAdditionalFiltersVisible) {
            this.hideAdditionalFilters();
            this.setState({filtersUnapplied: {}});

            return;
        }

        this.showAdditionalFilters();
    },
    hideAdditionalFilters() {
        this.setState({isAdditionalFiltersVisible: false});
        this.props.enableScroll();
    },
    showAdditionalFilters() {
        this.setState({isAdditionalFiltersVisible: true});
        this.props.disableScroll();
    }
}, {
    propTypes: {
        additionalFiltersKeys: propTypes.arrayOf(propTypes.string).isRequired,
        disableScroll: propTypes.func.isRequired,
        enableScroll: propTypes.func.isRequired,
        filterQueryStr: propTypes.func.isRequired,
        filtersKeys: propTypes.arrayOf(propTypes.string).isRequired,
        getFilters: propTypes.func.isRequired,
        updateQueryStr: propTypes.func.isRequired
    }
});
