import {decl} from 'bem';
import {connect} from 'react-redux';
import {bindActionCreators} from 'redux';
import {updateQueryStr, filterQueryStr} from 'tools-access-react-redux-router/src/actions';
import FiltersContainer from 'b:filters.container';
import {disableScroll, enableScroll} from '../../actions/page-scroll';

function mapStateToProps() {
    return {};
}

function mapDispatchToProps(dispatch) {
    return bindActionCreators({
        filterQueryStr,
        updateQueryStr,
        enableScroll,
        disableScroll
    }, dispatch);
}

const FiltersContainerConnected = connect(mapStateToProps, mapDispatchToProps)(FiltersContainer);

export default decl({block: 'filters.store-connected'}, () => FiltersContainerConnected);
