import React from 'react';
import propTypes from 'prop-types';
import {decl} from 'bem';
import Filter from 'e:filter m:type=textinput|suggest m:has-title';
import Controls from 'e:controls';
import i18n from 't:i18n';

export default decl({
    block: 'filters',
    elem: 'additional',

    content(props) {
        const {
            filters,
            getOnFilterChange,
            onApplyClick,
            onClearClick
        } = props;

        return [
            <Filter
                key="filter-issuer"
                type="suggest"
                has-title
                title={i18n('issuer')}
                placeholder={i18n('choose')}
                value={filters.requester}
                single
                onChange={getOnFilterChange('requester')}
                dataprovider={{pathname: '/api/frontend/suggest/users/'}}
            />,
            <Filter
                key="filter-host"
                type="suggest"
                has-title
                title={i18n('host')}
                placeholder={i18n('choose')}
                value={filters.host}
                single
                onChange={getOnFilterChange('host')}
                dataprovider={{pathname: '/api/frontend/suggest/hosts/'}}
            />,
            <Filter
                key="filter-can"
                type="suggest"
                has-title
                title="CA Name"
                placeholder={i18n('choose')}
                value={filters.ca_name}
                single
                onChange={getOnFilterChange('ca_name')}
                dataprovider={{pathname: '/api/frontend/suggest/ca_names/'}}
            />,
            <Filter
                key="filter-sn"
                type="textinput"
                has-title
                title={i18n('sn')}
                onChange={getOnFilterChange('serial_number')}
                value={filters.serial_number}
            />,
            <Filter
                key="filter-abc"
                type="suggest"
                has-title
                title={i18n('abc-service')}
                placeholder={i18n('choose')}
                value={filters.abc_service}
                single
                onChange={getOnFilterChange('abc_service')}
                dataprovider={{pathname: '/api/frontend/suggest/abc_services/'}}
            />,
            <Controls
                key="controls"
                onApplyClick={onApplyClick}
                onClearClick={onClearClick}
            />
        ];
    }
}, {
    propTypes: {
        filters: propTypes.shape({
            ca_name: propTypes.string.isRequired,
            requester: propTypes.string.isRequired,
            host: propTypes.string.isRequired,
            abc_service: propTypes.string.isRequired,
            serial_number: propTypes.string.isRequired
        }).isRequired,
        getOnFilterChange: propTypes.func.isRequired,
        onApplyClick: propTypes.func.isRequired,
        onClearClick: propTypes.func.isRequired
    }
});
