import React from 'react';
import PropTypes from 'prop-types';
import {decl} from 'bem';
import Button from 'b:button2 m:theme=action|clear m:size=m';
import i18n from 't:i18n';

export default decl({
    block: 'filters',
    elem: 'controls',

    content({onApplyClick, onClearClick}) {
        return [
            <Button
                key="apply"
                theme="action"
                size="m"
                onClick={onApplyClick}
                mix={{
                    block: this.block,
                    elem: 'apply'
                }}
            >
                {i18n('apply')}
            </Button>,
            <Button
                key="clear"
                theme="clear"
                size="m"
                onClick={onClearClick}
                mix={{
                    block: this.block,
                    elem: 'clear'
                }}
            >
                {i18n('clear')}
            </Button>
        ];
    }
}, {
    propTypes: {
        onApplyClick: PropTypes.func.isRequired,
        onClearClick: PropTypes.func.isRequired
    }
});
