import React from 'react';
import {declMod} from 'bem';
import TaSuggest from 'b:ta-suggest m:size=m m:single';
import compact from 'lodash/compact';

export default declMod({type: 'suggest'}, {
    block: 'filters',
    elem: 'filter',

    willInit() {
        this.handleChange = ::this.handleChange;
    },
    content({placeholder, dataprovider, single, value}) {
        return [
            <TaSuggest
                key="suggest"
                size="m"
                theme="normal"
                single={single}
                placeholder={placeholder}
                value={compact([value])}
                dataprovider={dataprovider}
                onChange={this.handleChange}
                mix={{
                    block: this.block,
                    elem: 'suggest-control'
                }}
            />
        ];
    },
    handleChange(value) {
        const {id = ''} = {...value};

        this.props.onChange(id);
    }
}, {
    propTypes: {
        // Todo: use when bem-react-core becomes work properly
    }
});
