import React from 'react';
import {declMod} from 'bem';
import Textinput from 'b:textinput m:theme=normal m:size=m';

export default declMod({type: 'textinput'}, {
    block: 'filters',
    elem: 'filter',

    content({onChange, value, placeholder}) {
        return [
            <Textinput
                key="textinput"
                theme="normal"
                size="m"
                mix={{
                    block: this.block,
                    elem: 'textinput'
                }}
                onChange={onChange}
                text={value}
                placeholder={placeholder}
            />
        ];
    }
}, {
    propTypes: {
        // Todo: use when bem-react-core becomes work properly
    }
});
