import React from 'react';
import propTypes from 'prop-types';
import {decl} from 'bem';
import Button from 'b:button2 m:size=m m:theme=normal m:type=check';
import Icon from 'b:icon m:type=filter';
import Filter from 'e:filter m:type=suggest m:quick';
import Ticker from 'e:ticker';
import i18n from 't:i18n';

export default decl({
    block: 'filters',
    elem: 'main',

    content() {
        const {
            filters,
            additionalFiltersAppliedNum,
            isAdditionalFiltersVisible,
            onToggleAdditionalFiltersClick,
            getOnFilterChange
        } = this.props;

        let buttonIcon;

        if (additionalFiltersAppliedNum > 0) {
            buttonIcon = <Ticker value={additionalFiltersAppliedNum} />;
        } else {
            buttonIcon = (
                <Icon
                    type="filter"
                    mix={{
                        block: this.block,
                        elem: 'icon-filter'
                    }}
                />
            );
        }

        return [
            <Filter
                key="filter-type"
                type="suggest"
                title=""
                text=""
                placeholder={i18n('filter-type')}
                quick
                single
                onChange={getOnFilterChange('type')}
                dataprovider={{pathname: '/api/frontend/suggest/cert_types/'}}
                value={filters.type}
            />,
            <Filter
                key="filter-status"
                type="suggest"
                title=""
                text=""
                placeholder={i18n('filter-status')}
                quick
                single
                onChange={getOnFilterChange('status')}
                dataprovider={{pathname: '/api/frontend/suggest/statuses/'}}
                value={filters.status}
            />,
            <Filter
                key="filter-owner"
                type="suggest"
                placeholder={i18n('owner')}
                quick
                single
                onChange={getOnFilterChange('user')}
                dataprovider={{pathname: '/api/frontend/suggest/users/'}}
                value={filters.user}
            />,
            <Filter
                key="filter-cn"
                type="textinput"
                placeholder="Common name"
                quick
                onChange={getOnFilterChange('common_name')}
                value={filters.common_name}
            />,
            <Button
                key="button"
                size="m"
                theme="normal"
                type="check"
                checked={isAdditionalFiltersVisible}
                mix={{
                    block: this.block,
                    elem: 'toggle-additional'
                }}
                onClick={onToggleAdditionalFiltersClick}
            >
                {buttonIcon}
                {i18n('filter')}
            </Button>
        ];
    }
}, {
    propTypes: {
        additionalFiltersAppliedNum: propTypes.number.isRequired,
        filters: propTypes.shape({
            ca_name: propTypes.string.isRequired,
            type: propTypes.string.isRequired,
            status: propTypes.string.isRequired,
            user: propTypes.string.isRequired,
            common_name: propTypes.string.isRequired
        }).isRequired,
        getOnFilterChange: propTypes.func.isRequired,
        isAdditionalFiltersVisible: propTypes.bool.isRequired,
        onToggleAdditionalFiltersClick: propTypes.func.isRequired
    }
});
