import React from 'react';
import propTypes from 'prop-types';
import {decl} from 'bem';
import Main from 'e:main';
import Additional from 'e:additional';
import Paranja from 'e:paranja';
import Component from 'b:ta-component';

export default decl(Component, {
    block: 'filters',

    content({isAdditionalFiltersVisible}) {
        const content = [
            <Main
                {...this.props}
                key="main"
            />
        ];

        if (isAdditionalFiltersVisible) {
            content.push(
                <Paranja key="paranja" />,
                <Additional
                    {...this.props}
                    key="additional"
                />
            );
        }

        return content;
    }
}, {
    propTypes: {
        isAdditionalFiltersVisible: propTypes.bool.isRequired
    }
});
