import {decl} from 'bem';
import PropTypes from 'prop-types';

export default decl({
    block: 'page-scroll.container',

    render() {
        const {pageScroll: isScrollable} = this.props;

        document.body.classList.toggle('unscrollable', !isScrollable);

        return null;
    }
}, {
    propTypes: {
        pageScroll: PropTypes.bool.isRequired
    }
});
