import React from 'react';
import {decl} from 'bem';
import Component from 'b:ta-component';
import Context, {Consumer} from 'tools-access-react-redux-router/src/context';
import Router from 'tools-access-react-redux-router/src/router';
import Route from 'tools-access-react-redux-router/src/route';
import Redirect from 'tools-access-react-redux-router/src/redirect';
import BPageSC from 'b:b-page.store-connected';

export default decl(Component, {
    block: 'routes',

    replace({path, dispatch}) {
        return (
            <Context
                path={path}
                dispatch={dispatch}
            >
                <Router>
                    <Route expr="/certificates">
                        <Consumer>
                            {({handleBubbledClickEvent}) =>
                                <BPageSC onClick={handleBubbledClickEvent} />
                            }
                        </Consumer>
                    </Route>
                    <Route expr="/">
                        <Redirect path="/certificates" />
                    </Route>
                </Router>
            </Context>
        );
    }
});
