import React from 'react';
import {decl} from 'bem';
import propTypes from 'prop-types';

export default decl({
    block: 'serial-number',

    content({value}) {
        if (!value) {
            return '–';
        }

        return value.split('').map((char, i) => (
            // eslint-disable-next-line react/no-array-index-key
            <span key={char + i}>
                {char}
            </span>
        ));
    }
}, {
    propTypes: {
        value: propTypes.string
    }
});
